/*  Project leowl_5
    xor@frognet.net
    Copyright  1996. Andrey B. Yastrebov. All Rights Reserved.

    SUBSYSTEM:    leowl_5.exe Application
    FILE:         leowl_5e.cpp
    AUTHOR:       Andrey B. Yastrebov


    OVERVIEW
    ========
    Source file for implementation of leowl_5Edit (TWindow).
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include "leowl_5.h"
#include "leowl_5e.h"

//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(leowl_5Edit, TLEdit)
//{{leowl_5EditRSP_TBL_BEGIN}}
    EV_COMMAND(CM_PICTURE, CmPicture),
    EV_COMMAND_ENABLE(CM_PICTURE, CmCommandEnable),
//{{leowl_5EditRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{leowl_5Edit Implementation}}


//////////////////////////////////////////////////////////
// leowl_5Edit
// ==========
// Construction/Destruction handling.
leowl_5Edit::leowl_5Edit (TWindow* parent,
                          const char far* title,
                          TModule* module)
    : TLEdit(parent, title,
    ES_SMALLINDENT | ES_SMALLSPACING | ES_TRANSPARENT | WS_HSCROLL | WS_VSCROLL
    ,module)
{
   // Change a little LEdit behaviour
   lpFont = new TFont((HFONT) GetStockObject(DEVICE_DEFAULT_FONT));
   SetSyntax("0");

   UseMemoryDC = TRUE;

   BitMap = new TBitmap(GetModule()->GetInstance(),TResId(IDBM_COVER));
   BitMapX = 80;
   BitMapY = 32;
}

leowl_5Edit::~leowl_5Edit ()
{
    if (BitMap)
      delete BitMap;
    Destroy();
}

void leowl_5Edit::SetupWindow ()
{
    TLEdit::SetupWindow();

    LoadFromFile("leowl_5e.cpp");
}

void leowl_5Edit::Paint (TDC& dc, BOOL /*erase*/, TRect& rect)
{
    if (! BitMap)
      {
        MessageBox(0);
        return;
      }

    TMemoryDC* MDC = new TMemoryDC(dc);
    if (MDC)
      {
        MDC->SelectObject(*BitMap);
        int x, y;
        for (x = 0; x < rect.right; x += BitMapX)
          for (y = 0; y < rect.bottom; y += BitMapY)
            dc.BitBlt(x,y,BitMapX,BitMapY,*MDC,0,0);
      }
    delete MDC;
}

void leowl_5Edit::CmPicture ()
{
    UseMemoryDC = ! UseMemoryDC;
}


void leowl_5Edit::CmCommandEnable (TCommandEnabler &tce)
{
    tce.Enable(TRUE);
    tce.SetCheck(UseMemoryDC ? TCommandEnabler::Checked :
                               TCommandEnabler::Unchecked);
}


